﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Place" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Deklaracja RMUA</title>
		<script runat="server">

            public class Params : ContextBase {
                public Params(Context context) : base(context) {
                }

                bool naliczone = false;
                [Caption("Tylko naliczone")]
                public bool Naliczone {
                    get { return naliczone; }
                    set {
                        naliczone = value;
                        OnChanged(EventArgs.Empty);
                    }
                }
            }

            Params pars;
            [Context]
            public Params Pars {
                set { pars = value; }
            }

            string NBSP(string ss) {
                return ss == "" ? empty : ss;
            }

            void LiczDaneFirmy() {
                CoreModule core = CoreModule.GetInstance(dc);
                DeklaracjeModule dek = DeklaracjeModule.GetInstance(dc);
                IPieczątkaFirmy pf = ReportHeader.GetPieczątka(dc);
                string nip = pf.NIP;
                string regon = pf.REGON;
                string nazwask = pf.NazwaSkrócona;
                NIP.EditValue = NBSP(nip);
                REGON.EditValue = NBSP("");
                PESEL.EditValue = NBSP("");
                DOKUMENT.EditValue = NBSP("");
                IMIE.EditValue = NBSP("");
                NAZWISKO.EditValue = NBSP("");
                URODZONY.EditValue = NBSP("");
                NAZWASK.EditValue = NBSP(nazwask);
                if (regon != "")
                    REGON.EditValue = NBSP(regon);
                if (nip == "" || regon == "")
                    if (core.Config.Firma.DaneEwidencyjne.OsobaFizyczna) {
                        string pesel = core.Config.Firma.DaneEwidencyjne.PESEL;
                        if (pesel == "") {
                            Wlasciciel wls = dek.Config.ZUS.Ogólne.DaneWłaściciela;
                            if (wls != null) {
                                pesel = NBSP(wls.Last.PESEL);
                                IMIE.EditValue = NBSP(wls.Imie);
                                NAZWISKO.EditValue = NBSP(wls.Nazwisko);
                                if (pesel == "") {
                                    RODZAJDOK.EditValue = (wls.Last.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty ? "1" : "2");
                                    DOKUMENT.EditValue = NBSP(wls.Last.Dokument.SeriaNumer);
                                }
                            }
                        }
                        if (pesel != "")
                            PESEL.EditValue = NBSP(pesel);
                    }
            }

            void LiczDanePracownika(Pracownik p, Date data) {
                PracHistoria ph = p[data];
                /*
                switch (ph.Plec) {
                    case PłećOsoby.Kobieta:
                        PracZam.EditValue = "zamieszkała";
                        PracPlec.EditValue = "Pani";
                        break;
                    case PłećOsoby.Mężczyzna:
                        PracZam.EditValue = "zamieszkały";
                        PracPlec.EditValue = "Pan";
                        break;
                }
                */
                PracNazw.EditValue = ph.Nazwisko;
                PracImie.EditValue = ph.Imie;
                //PracAdres1.EditValue = ph.Adres.Linia1;
                //PracAdres2.EditValue = ph.Adres.Linia2;
                //PracPesel.EditValue = ph.PESEL;
                RODZAJUBEZP.EditValue = NBSP("");
                DOKUBEZP.EditValue = NBSP("");
                if (ph.PESEL != "") {
                    RODZAJUBEZP.EditValue = NBSP("P");
                    DOKUBEZP.EditValue = NBSP(ph.PESEL);
                }
                else {
                    if (ph.Dokument.Rodzaj != KodRodzajuDokumentu.Niezdefiniowany) {
                        RODZAJUBEZP.EditValue = (ph.Dokument.Rodzaj == KodRodzajuDokumentu.DowodOsobisty ? "1" : "2");
                        DOKUBEZP.EditValue = NBSP(ph.Dokument.SeriaNumer);
                    }
                    else if (ph.Obywatelstwo.RodzajNumeruPodatnika != KodRodzajNumeruPodatnika.Nieokreślony) {
                        RODZAJUBEZP.EditValue = "2";
                        DOKUBEZP.EditValue = NBSP(ph.Obywatelstwo.NumerPodatnika);
                    }
                }
            }

            string[] bloki = {
                "DSMRMUA",
                "DLMRMUA",
                "DMMRMUA",
                "DKMRMUA",
                "DJMRMUA",
                "DCMRMUA",
                "DPMRMUA",
                "DRMRMUA",
                "DWMRMUA",
                "DZMRMUA",
                "DTMRMUA",
                "DGMRMUA" };

            Soneta.Deklaracje.ZUS.RMUA rmua = null;

            void IlePrzerw(YearMonth ym, ref List<string> lista) {
                string nazwa = bloki[ym.Month - 1];
                BlokDeklaracji blok = rmua.Bloki[nazwa];
                string przerwy = (string)blok["Przerwy"];
                string[] linie = przerwy.Split('#');
                foreach (string linia in linie) {
                    string[] elementy = linia.Split('|');
                    if (elementy.Length != 6)
                        continue;
                    string t = elementy[0];
                    if (!lista.Contains(t))
                        lista.Add(t);
                }
            }

            void IleDeklaracji(YearMonth ym, ref List<string> lista) {
                string nazwa = bloki[ym.Month - 1];
                BlokDeklaracji blok = rmua.Bloki[nazwa];
                string t = (string)blok["Tyub"];
                if (t == "") {
                    IlePrzerw(ym, ref lista);
                    if (lista.Count == 0 && !pars.Naliczone)
                        lista.Add(empty);
                    return;
                }
                lista.AddRange(t.Split('#'));
                IlePrzerw(ym, ref lista);
            }

            class Dek {
                public YearMonth ym;
                public string tu;
                public Dek(YearMonth ym, string tu) {
                    this.ym = ym;
                    this.tu = tu;
                }
            }

            List<Dek> lista = new List<Dek>();

            void OnContextLoad(Object sender, EventArgs args) {
                rmua = (Soneta.Deklaracje.ZUS.RMUA)dc[typeof(Soneta.Deklaracje.ZUS.RMUA)];

                bool miesieczna = rmua.IsDeklaracjaMiesieczna;
                ReportHeader1["TYTUL"] = (miesieczna ? "INFORMACJA MIESIĘCZNA DLA OSOBY UBEZPIECZONEJ " : "INFORMACJA ROCZNA DLA OSOBY UBEZPIECZONEJ ") + rmua.Pracownik.NazwiskoImię;
                NumerDok.EditValue = GetNumerDok(rmua);
                NumerLabel.EditValue = miesieczna ? "(numer/mm/rrrr)" : "(numer/rrrr)";

                LiczDaneFirmy();
                LiczDanePracownika(rmua.Pracownik, rmua.Data);

                YearMonth ym;
                List<string> tyub = new List<string>();
                if (miesieczna) {
                    tyub.Clear();
                    ym = rmua.RokMiesiac;
                    IleDeklaracji(ym, ref tyub);
                    if (!pars.Naliczone || tyub.Count > 0)
                        foreach (string tu in tyub)
                            lista.Add(new Dek(ym, tu));
                }
                else
                    for (int i = 1; i <= 12; i++) {
                        tyub.Clear();
                        ym = new YearMonth(rmua.Rok, i);
                        IleDeklaracji(ym, ref tyub);
                        if (!pars.Naliczone || tyub.Count > 0)
                            foreach (string tu in tyub)
                                lista.Add(new Dek(ym, tu));
                    }

                DataRepeater1.DataSource = lista;
            }

            string GetNumerDok(Soneta.Deklaracje.ZUS.RMUA rmua) {
                if (rmua.IsDeklaracjaMiesieczna)
                    return string.Format("{0} {1}/{2}", rmua.Numer.Numer, rmua.RokMiesiac.Month, rmua.Rok);
                else
                    return string.Format("{0} {1}", rmua.Numer.Numer, rmua.Rok);
            }

            int GetBlokNr(object value, string tyub, int nr) {
                int poz = 0;
                string t = value.ToString();
                string[] b = t.Split('#');
                for (int i = 0; i < b.Length; i++)
                    if (b[i] == tyub) {
                        if (poz == nr)
                            return i;
                        poz++;
                    }
                return -1;
            }

            //decimal sum = 0;
            string zero = "0,00";
            string empty = "&nbsp;";
            string przerwy = "";
            string prev = "";

            string GetBlok(object value, int nr, bool format = true, bool join = false) {
                string t = value.ToString();
                string[] b = t.Split(join ? '|' : '#');
                string v = "";
                if (nr != -1 && b.Length > nr)
                    v = b[nr];
                if (v == "")
                    v = format ? zero : empty;
                return v;
            }

            string GetBlok2(object value, int pos, int nr, bool format = true) {
                string t = GetBlok(value, nr, format, false);
                string v = GetBlok(t, pos, format, true);
                return v;
            }

            string GetTyub(string t) {
                int ty = 0;
                try {
                    ty = int.Parse(t);
                }
                catch {
                    return t;
                }
                TytulUbezpieczenia tyub = new TytulUbezpieczenia(ty);
                if (tyub == null)
                    return t;
                return tyub.ToString();
            }

            Dictionary<string, int> dict = new Dictionary<string, int>();

            void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
                string sp = System.Globalization.CultureInfo.CurrentUICulture.NumberFormat.NumberDecimalSeparator;
                Dek dek = (Dek)DataRepeater1.CurrentRow;

                YearMonth ym = dek.ym;
                string tyub = dek.tu;
                string nazwa = bloki[ym.Month - 1];
                BlokDeklaracji blok = rmua.Bloki[nazwa];
                List<string> sumaSkl = new List<string>();
                bool fix = false, fix1 = false, fix2 = false;
                int idx;

                string t = "", e = "", n = "";

                string key = string.Format("{0}:{1}", ym, tyub);
                if (!dict.ContainsKey(key))
                    dict.Add(key, 0);
                else
                    dict[key]++;

                int nr = GetBlokNr(blok["Tyub"], tyub, dict[key]);
                e = GetBlok(blok["WmEtat"], nr, false);
                if (tyub != empty) {
                    t = GetTyub(tyub);
                    PracHistoria ph = rmua.Pracownik[ym.LastDay];
                    n = ph.OddzialNFZ != null ? ph.OddzialNFZ.Kod : "";
                    fix = t.StartsWith("1211") || t.StartsWith("1240");
                    fix1 = (GetBlok(blok["UbEmPl"], nr)  != zero ||
                            GetBlok(blok["UbRenPl"], nr) != zero ||
                            GetBlok(blok["UbChrPl"], nr) != zero ||
                            GetBlok(blok["UbWyp"], nr)   != zero ||
                            GetBlok(blok["UbZdrPl"], nr) != zero);
                    fix2 = GetBlok(blok["UbZdr"], nr) != zero;
                }

                string row = "";
                if (!rmua.IsDeklaracjaMiesieczna) {
                    bool per = true;
                    idx = lista.IndexOf(dek);
                    if (idx != -1 && idx > 0) {
                        Dek dek2 = lista[idx - 1];
                        per = dek.ym != dek2.ym;
                    }
                    if (per) {
                        row = periodrow;
                        row = row.Replace("#Okres#", ym.ToString(null, new System.Globalization.CultureInfo("pl-PL")));
                    }
                }

                string row2 = "";
                string pv = t + e + n;
                //bool diff = (prev != pv);
                //if (diff) {
                row += datarow;
                row += deschead;
                prev = pv;
                //}
                row += descrow;
                row2 += datarow2;

                //row = row.Replace("#OkresR#", string.Format("{0}", ym.Month));
                row = row.Replace("#KodTyUb#", t);
                row = row.Replace("#KodNFZ#", n);
                row = row.Replace("#KodPrzek#", GetBlok(blok["KodPrzek"], nr, false));
                row = row.Replace("#WmEtat#", e != empty ? e : "");

                row = row.Replace("#UbEmRenP1#", GetBlok(blok["UbEmRenP"], nr));
                row = row.Replace("#UbEmRenP2#", GetBlok(blok["UbEmRenP"], nr));
                row = row.Replace("#UbEmUb#", GetBlok(blok["UbEmUb"], nr));
                row = row.Replace("#UbRenUb#", GetBlok(blok["UbRenUb"], nr));
                row = row.Replace("#UbChrWypP1#", GetBlok(blok["UbChrWypP"], nr));
                row = row.Replace("#UbChrWypP2#", GetBlok(blok["UbWypP"], nr));
                row = row.Replace("#UbChr#", GetBlok(blok["UbChr"], nr));
                row = row.Replace("#UbWypUb#", GetBlok(blok["UbWypUb"], nr));
                row = row.Replace("#UbEmFK#", GetBlok2(blok["UbEmerFK"], 0, nr));
                row = row.Replace("#UbRenFK#", GetBlok2(blok["UbRentFK"], 0, nr));
                row = row.Replace("#UbChrFK#", GetBlok2(blok["UbChorFK"], 0, nr));
                row = row.Replace("#UbWypFK#", GetBlok2(blok["UbWypadFK"], 0, nr));
                row = row.Replace("#UbEmFR#", GetBlok2(blok["UbEmerFK"], 1, nr));
                row = row.Replace("#UbRenFR#", GetBlok2(blok["UbRentFK"], 1, nr));
                row = row.Replace("#UbChrFR#", GetBlok2(blok["UbChorFK"], 1, nr));
                row = row.Replace("#UbWypFR#", GetBlok2(blok["UbWypadFK"], 1, nr));
                row2 = row2.Replace("#UbZdrP#", GetBlok(blok["UbZdrP"], nr));
                row2 = row2.Replace("#UbZdrFK#", GetBlok2(blok["UbZdrowFK"], 0, nr));

                sumaSkl.Add(GetBlok(blok["UbEmUb"], nr));
                sumaSkl.Add(GetBlok(blok["UbRenUb"], nr));
                sumaSkl.Add(GetBlok(blok["UbChr"], nr));
                sumaSkl.Add(GetBlok(blok["UbWypUb"], nr));

                sumaSkl.Add(GetBlok2(blok["UbEmerFK"], 0, nr));
                sumaSkl.Add(GetBlok2(blok["UbRentFK"], 0, nr));
                sumaSkl.Add(GetBlok2(blok["UbChorFK"], 0, nr));
                sumaSkl.Add(GetBlok2(blok["UbWypadFK"], 0, nr));

                sumaSkl.Add(GetBlok2(blok["UbEmerFK"], 1, nr));
                sumaSkl.Add(GetBlok2(blok["UbRentFK"], 1, nr));
                sumaSkl.Add(GetBlok2(blok["UbChorFK"], 1, nr));
                sumaSkl.Add(GetBlok2(blok["UbWypadFK"], 1, nr));

                if (fix && fix1) {
                    row = row.Replace("#UbEmBp#", GetBlok(blok["UbEmPl"], nr));
                    row = row.Replace("#UbRenBp#", GetBlok(blok["UbRenPl"], nr));
                    row = row.Replace("#UbChrBp#", GetBlok(blok["UbChrPl"], nr));
                    row = row.Replace("#UbWypBp#", GetBlok(blok["UbWyp"], nr));
                    row = row.Replace("#UbEmPl#", GetBlok(blok["UbEmerBp"], nr));
                    row = row.Replace("#UbRenPl#", GetBlok(blok["UbRentBp"], nr));
                    row = row.Replace("#UbChrPl#", GetBlok(blok["UbChorBp"], nr));
                    row = row.Replace("#UbWyp#", GetBlok(blok["UbWypadBp"], nr));
                    row2 = row2.Replace("#UbZdrPl#", GetBlok(blok["UbZdrowBp"], nr));

                    sumaSkl.Add(GetBlok(blok["UbEmerBp"], nr));
                    sumaSkl.Add(GetBlok(blok["UbRentBp"], nr));
                    sumaSkl.Add(GetBlok(blok["UbChorBp"], nr));
                    sumaSkl.Add(GetBlok(blok["UbWypadBp"], nr));

                    sumaSkl.Add(GetBlok(blok["UbEmPl"], nr));
                    sumaSkl.Add(GetBlok(blok["UbRenPl"], nr));
                    sumaSkl.Add(GetBlok(blok["UbChrPl"], nr));
                    sumaSkl.Add(GetBlok(blok["UbWyp"], nr));
                }
                else {
                    row = row.Replace("#UbEmPl#", GetBlok(blok["UbEmPl"], nr));
                    row = row.Replace("#UbRenPl#", GetBlok(blok["UbRenPl"], nr));
                    row = row.Replace("#UbChrPl#", GetBlok(blok["UbChrPl"], nr));
                    row = row.Replace("#UbWyp#", GetBlok(blok["UbWyp"], nr));
                    row2 = row2.Replace("#UbZdrPl#", GetBlok(blok["UbZdrPl"], nr));
                    row = row.Replace("#UbEmBp#", GetBlok(blok["UbEmerBp"], nr));
                    row = row.Replace("#UbRenBp#", GetBlok(blok["UbRentBp"], nr));
                    row = row.Replace("#UbChrBp#", GetBlok(blok["UbChorBp"], nr));
                    row = row.Replace("#UbWypBp#", GetBlok(blok["UbWypadBp"], nr));

                    sumaSkl.Add(GetBlok(blok["UbEmPl"], nr));
                    sumaSkl.Add(GetBlok(blok["UbRenPl"], nr));
                    sumaSkl.Add(GetBlok(blok["UbChrPl"], nr));
                    sumaSkl.Add(GetBlok(blok["UbWyp"], nr));

                    sumaSkl.Add(GetBlok(blok["UbEmerBp"], nr));
                    sumaSkl.Add(GetBlok(blok["UbRentBp"], nr));
                    sumaSkl.Add(GetBlok(blok["UbChorBp"], nr));
                    sumaSkl.Add(GetBlok(blok["UbWypadBp"], nr));
                }
                string ubb = zero, ubz = zero;
                if (fix && fix2) {
                    ubb = GetBlok(blok["UbZdr"], nr);
                    row2 = row2.Replace("#UbZdrBp#", ubb);
                    row2 = row2.Replace("#UbZdrUb#", ubz);
                }
                else {
                    if (fix && fix1)
                        ubb = GetBlok(blok["UbZdrPl"], nr);
                    else
                        ubb = GetBlok(blok["UbZdrowBp"], nr);
                    ubz = GetBlok(blok["UbZdr"], nr);
                    row2 = row2.Replace("#UbZdrBp#", ubb);
                    row2 = row2.Replace("#UbZdrUb#", ubz);
                }
                //sumaSkl.Add(ubb);
                //sumaSkl.Add(ubz);

                decimal suma = 0;
                foreach (string skl in sumaSkl) {
                    string sk = "";
                    for (int ii = 0; ii < skl.Length; ii++)
                        if (skl[ii] != 0xa0) sk += skl[ii];
                    suma += ToDecimal(sk);
                }
                //sum += suma;
                //row = row.Replace("#SumaUb#", string.Format("{0:n}", suma));

                row += sumrow;
                row = row.Replace("#KwotaObn#", GetBlok(blok["KwotaObn"], nr));
                row = row.Replace("#SumaSumUb#", string.Format("{0:n}", suma));

                DataRow1.EditValue = row;
                DataRow2.EditValue = row2;
                DataRow3.EditValue = "";
                przerwy += Przerwy(blok, tyub);
                bool prz = true;
                idx = lista.IndexOf(dek);
                if (idx != -1 && idx < lista.Count-1) {
                    Dek dek2 = lista[idx + 1];
                    prz = dek.ym != dek2.ym;
                }
                if (przerwy != "" && prz) {
                    DataRow3.EditValue = tabhead + przerwy;
                    przerwy = "";
                }
            }

            private decimal ToDecimal(string str) {
                decimal value = 0;
                try {
                    value = Convert.ToDecimal(str.Replace(".", ","));
                }
                catch {
                    value = Convert.ToDecimal(str.Replace(",", "."));
                }
                return value;
            }

            string Przerwy(BlokDeklaracji blok, string tyub) {
                string sp = System.Globalization.CultureInfo.CurrentUICulture.NumberFormat.NumberDecimalSeparator;
                string row, rows = "";

                string przerwy = (string)blok["Przerwy"];
                string[] linie = przerwy.Split('#');
                foreach (string linia in linie) {
                    string[] elementy = linia.Split('|');
                    if (elementy.Length != 6)
                        continue;
                    string t = elementy[0];
                    if (tyub != t)
                        continue;
                    row = tabrow;
                    row = row.Replace("#1#", KodRSA(elementy[1]));
                    row = row.Replace("#2#", elementy[3].Substring(0, 10));
                    row = row.Replace("#3#", elementy[3].Substring(13, 10));
                    row = row.Replace("#4#", elementy[4]);
                    string kw = "", str = elementy[5];
                    for (int ii = 0; ii < str.Length; ii++)
                        if (str[ii] != 0xa0) kw += str[ii];
                    decimal kwota = ToDecimal(kw);
                    row = row.Replace("#5#", string.Format("{0:n}", kwota));
                    rows += row;
                }

                return rows;
            }

            string KodRSA(string element) {
                string opis = element;
                try {
                    int kod = int.Parse(element);
                    KodRSA rsa = PlaceModule.GetInstance(dc).KodyRSA.WgKodu[kod];
                    if (rsa != null)
                        opis = rsa.Opis;
                }
                catch { }
                return opis;
            }

            public static void Msg(object obj) {
            }

            static string tabhead = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>" +
                "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
                "<TR>" +
                "<TD><FONT face=\"Arial\" size=\"1\"><b>III. D. ZESTAWIENIE WYPŁACONYCH ŚWIADCZEŃ I WYNAGRODZEŃ ZA CZAS ABSENCJI CHOROBOWEJ ORAZ RODZAJE I OKRESY PRZERW W OPŁACANIU SKŁADEK</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>" +
                "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" style=\"BORDER:silver 1px solid\">" +
                "<TR>" +
                "<TD width=\"60%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">01. Kod świadczenia/przerwy</FONT></TD>" +
                "<TD width=\"20%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">02. Okres od - do (dd/mm/rrrr)</FONT></TD>" +
                "<TD width=\"10%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">03. Liczba dni zasiłkowych</FONT></TD>" +
                "<TD width=\"10%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">04. Kwota</FONT></TD>" +
                "</TR>" +
                "</TABLE>";

            static string tabrow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"0\">" +
                "<TR>" +
                "<TD width=\"60%\" Align=\"Left\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-LEFT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">#1#</FONT></TD>" +
                "<TD width=\"20%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#2# - #3#</b></FONT></TD>" +
                "<TD width=\"10%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#4#</b></FONT></TD>" +
                "<TD width=\"10%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#5#</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>";

            static string periodrow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>" +
                "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
                "<TR>" +
                "<TD><FONT face=\"Arial\" size=\"2\"><b>Okres rozliczeniowy: #Okres#</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>";

            static string datarow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>" +
                "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
                "<TR>" +
                "<TD><FONT face=\"Arial\" size=\"1\"><b>III. B. ZESTAWIENIE NALEŻNYCH SKŁADEK NA UBEZPIECZENIA SPOŁECZNE</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>" +
                "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
                "<TR>" +
                "<TD width=\"20%\" valign=\"bottom\"><FONT face=\"Arial\" size=\"1\">01. Kod tytułu ubezpieczenia</FONT></TD>" +
                "<TD width=\"20%\" valign=\"bottom\"><FONT face=\"Arial\" size=\"1\">02. Kod NFZ</FONT></TD>" +
                "<TD width=\"40%\" valign=\"bottom\"><FONT face=\"Arial\" size=\"1\">03. Informacja o przekroczeniu rocznej podstawy wymiaru składek na ubezpieczenia emerytalne i rentowe</FONT></TD>" +
                "<TD width=\"20%\" valign=\"bottom\"><FONT face=\"Arial\" size=\"1\">04. Wymiar czasu</FONT></TD>" +
                "</TR>" +
                "</TABLE>" +
                "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
                "<TR>" +
                "<TD width=\"18%\" valign=\"bottom\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#KodTyUb#</b></FONT></TD>" +
                "<TD width=\"2%\"></TD>" +
                "<TD width=\"18%\" valign=\"bottom\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#KodNFZ#</b></FONT></TD>" +
                "<TD width=\"2%\"></TD>" +
                "<TD width=\"38%\" valign=\"bottom\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#KodPrzek#</b></FONT></TD>" +
                "<TD width=\"2%\"></TD>" +
                "<TD width=\"20%\" valign=\"bottom\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#WmEtat#</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>" +
                "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>";

            static string datarow2 = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>" +
                "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\">" +
                "<TR>" +
                "<TD><FONT face=\"Arial\" size=\"1\"><b>III. C. ZESTAWIENIE NALEŻNYCH SKŁADEK NA UBEZPIECZENIE ZDROWOTNE</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>" +
                "<TABLE cellSpacing=\"4\" cellPadding=\"0\" width=\"100%\">" +
                "<TR>" +
                "<TD width=\"30%\"><FONT face=\"Arial\" size=\"1\">01. Podstawa wymiaru składki</FONT></TD>" +
                "<TD width=\"2%\"></TD>" +
                "<TD width=\"14%\" align=\"right\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrP#</b></FONT></TD>" +
                "<TD width=\"5%\"></TD>" +
                "<TD width=\"30%\"></TD>" +
                "<TD width=\"5%\"></TD>" +
                "<TD width=\"14%\"></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"30%\"><FONT face=\"Arial\" size=\"1\">02. Kwota należnej składki finansowanej przez płatnika</FONT></TD>" +
                "<TD width=\"2%\"></TD>" +
                "<TD width=\"14%\" align=\"right\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrPl#</b></FONT></TD>" +
                "<TD width=\"5%\"></TD>" +
                "<TD width=\"30%\"><FONT face=\"Arial\" size=\"1\">04. Kwota należnej składki finansowanej z budżetu państwa bezpośrednio do ZUS</FONT></TD>" +
                "<TD width=\"5%\"></TD>" +
                "<TD width=\"14%\" align=\"right\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrBp#</b></FONT></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"30%\"><FONT face=\"Arial\" size=\"1\">03. Kwota należnej składki finansowanej przez ubezpieczonego</FONT></TD>" +
                "<TD width=\"2%\"></TD>" +
                "<TD width=\"14%\" align=\"right\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrUb#</b></FONT></TD>" +
                "<TD width=\"5%\"></TD>" +
                "<TD width=\"30%\"><FONT face=\"Arial\" size=\"1\">05. Kwota należnej składki finansowanej przez Fundusz Kościelny</FONT></TD>" +
                "<TD width=\"5%\"></TD>" +
                "<TD width=\"14%\" align=\"right\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrFK#</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>";

            /*
            static string deschead = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" style=\"BORDER:silver 1px solid\">" +
                "<TR>" +
                "<TD width=\"4.0%\"  Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\" rowspan=\"2\"><FONT face=\"Arial\" size=\"1\">mc</FONT></TD>" +
                "<TD width=\"32.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\" colspan=\"4\"><FONT face=\"Arial\" size=\"1\">Podstawa wymiaru składek</FONT></TD>" +
                "<TD width=\"56.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\" colspan=\"7\"><FONT face=\"Arial\" size=\"1\">Ubezpieczenie</FONT></TD>" +
                "<TD width=\"8.0%\"  Align=\"Center\" rowspan=\"2\"><FONT face=\"Arial\" size=\"1\">Łączna kwota składek</FONT></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">em. i rn.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">chor.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">wyp.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">zdrowotne</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">emer.pł.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">emer.ub.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">rent.pł.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">rent.ub.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">chorob.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">wypadk.</FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">zdrowot.</FONT></TD>" +
                "</TR>" +
                "</TABLE>";
            */

            static string deschead = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" style=\"BORDER-TOP:silver 1px solid; BORDER-LEFT:silver 1px solid; BORDER-RIGHT:silver 1px solid\">" +
                "<TR>" +
                "<TD width=\"20.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">UBEZPIECZENIE</FONT></TD>" +
                "<TD width=\"20.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\">EMERYTALNE</FONT></TD>" +
                "<TD width=\"20.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\">RENTOWE</FONT></TD>" +
                "<TD width=\"20.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\">CHOROBOWE</FONT></TD>" +
                "<TD width=\"20.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\">WYPADKOWE</FONT></TD>" +
                "</TR>" +
                "</TABLE>";

            /*
            static string descrow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"0\">" +
                "<TR>" +
                "<TD width=\"4.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-LEFT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#OkresR#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmRenP1#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrWypP1#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrWypP2#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrP#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmPl#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmUb#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenPl#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenUb#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbChr#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbWyp#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbZdrUb#</b></FONT></TD>" +
                "<TD width=\"8.0%\" Align=\"Right\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#SumaUb#</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>";
            */

            static string descrow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" style=\"BORDER:silver 1px solid\">" +
                "<TR>" +
                "<TD width=\"20.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid; BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">PODSTAWA WYMIARU SKŁADKI</FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\" style=\"BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">05.</FONT></TD>" +
                "<TD width=\"35.0%\" Align=\"Center\" style=\"BORDER-BOTTOM:silver 1px solid\" colspan=\"3\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmRenP1#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\" style=\"BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">06.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\" style=\"BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrWypP1#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\" style=\"BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">07.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\" style=\"BORDER-BOTTOM:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrWypP2#</b></FONT></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"20.0%\" Align=\"Center\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">SKŁADKI FINANSOWANE PRZEZ:</FONT></TD>" +
                "<TD width=\"80.0%\" Align=\"Right\" colspan=\"8\"></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"20.0%\" Align=\"Left\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">ubezpieczonych</FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">08.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmUb#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">09.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenUb#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">10.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbChr#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">11.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbWypUb#</b></FONT></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"20.0%\" Align=\"Left\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">płatnika</FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">12.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmPl#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">13.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenPl#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">14.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrPl#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">15.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbWyp#</b></FONT></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"20.0%\" Align=\"Left\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">budżet państwa</FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">16.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmBp#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">17.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenBp#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">18.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrBp#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">19.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbWypBp#</b></FONT></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"20.0%\" Align=\"Left\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">PFRON <sup>2)</sup></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">20.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmFR#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">21.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenFR#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">22.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrFR#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">23.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbWypFR#</b></FONT></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"20.0%\" Align=\"Left\" style=\"BORDER-RIGHT:silver 1px solid\"><FONT face=\"Arial\" size=\"1\">Fundusz Kościelny</FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">24.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbEmFK#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">25.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbRenFK#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">26.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbChrFK#</b></FONT></TD>" +
                "<TD width=\"5.0%\" Align=\"Center\"><FONT face=\"Arial\" size=\"1\">27.</FONT></TD>" +
                "<TD width=\"15.0%\" Align=\"Right\"><FONT face=\"Arial\" size=\"1\"><b>#UbWypFK#</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>";

            static string sumrow = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" height=\"8px\"><TR><TD></TD></TR></TABLE>" +
                "<TABLE cellSpacing=\"4\" cellPadding=\"0\" width=\"100%\">" +
                "<TR>" +
                "<TD width=\"87%\"><FONT face=\"Arial\" size=\"1\">28. Kwota obniżenia podstawy wymiaru składek na ubezpieczenia społeczne z tytułu opłacania składki w ramach pracowniczego programu emerytalnego</FONT></TD>" +
                "<TD width=\"13%\" Align=\"Right\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#KwotaObn#</b></FONT></TD>" +
                "</TR>" +
                "<TR>" +
                "<TD width=\"87%\"><FONT face=\"Arial\" size=\"1\">29. Łączna kwota składek (suma od p. 08 do p. 27)</FONT></TD>" +
                "<TD width=\"13%\" Align=\"Right\" style=\"BORDER:silver 1px solid\"><FONT face=\"Arial\" size=\"1\"><b>#SumaSumUb#</b></FONT></TD>" +
                "</TR>" +
                "</TABLE>";

</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body style="font-family: Times New Roman">
		<form id="DeklaracjaRMUA" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Deklaracje.ZUS.RMUA,Soneta.Deklaracje"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="%TYTUL%" runat="server"></cc1:reportheader>
			<TABLE id="Table8" cellSpacing="0" cellPadding="0" width="100%">
				<TR>
					<TD width="100%"><FONT face="Arial" size="1"><b>I. DANE ORGANIZACYJNE</b></FONT></TD>
				</TR>
			</TABLE>
			<TABLE id="Table7" cellSpacing="0" cellPadding="0" width="50%">
				<TR>
					<TD width="60%"><FONT face="Arial" size="1">01. Identyfikator informacji <ea:DataLabel id="NumerLabel" runat="server" Bold="false"></ea:DataLabel></FONT></TD>
					<TD width="40%" style="BORDER:silver 1px solid"><FONT face="Arial" size="1"><ea:DataLabel id="NumerDok" runat="server"></ea:DataLabel></FONT></TD>
				</TR>
			</TABLE>
			<TABLE cellSpacing="0" cellPadding="0" height="8px"><TR><TD></TD></TR></TABLE>
			<TABLE id="Table8" cellSpacing="0" cellPadding="0" width="100%">
				<TR>
					<TD width="100%"><FONT face="Arial" size="1"><b>II. DANE IDENTYFIKACYJNE PŁATNIKA SKŁADEK</b></FONT></TD>
				</TR>
			</TABLE>
			<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="0">
				<TR>
					<TD width="48%"><FONT face="Arial" size="1">01. Numer NIP</FONT></TD>
					<TD width="4%"></TD>
					<TD width="48%"><FONT face="Arial" size="1">02. Numer REGON</FONT></TD>
				</TR>
				<TR>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="NIP" runat="server"></ea:DataLabel></FONT>
                    </TD>
					<TD></TD>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="REGON" runat="server"></ea:DataLabel></FONT>
                    </TD>
				</TR>
            </TABLE>
			<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="0">
				<TR>
					<TD valign="bottom" width="48%"><FONT face="Arial" size="1">03. Numer PESEL <sup>1)</sup></FONT></TD>
					<TD width="4%"></TD>
					<TD width="20%"><FONT face="Arial" size="1">04. Rodzaj dokumentu:<br />jeśli dowód osobisty, wpisać 1,<br />jeśli paszport - 2</FONT></TD>
					<TD width="2%"></TD>
					<TD width="26%" valign="bottom"><FONT face="Arial" size="1">05. Seria i numer dokumentu</FONT></TD>
				</TR>
				<TR>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="PESEL" runat="server"></ea:DataLabel></FONT>
                    </TD>
					<TD></TD>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1">
                            <ea:DataLabel id="RODZAJDOK" runat="server"></ea:DataLabel>
                        </FONT>
                    </TD>
					<TD></TD>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1">
                            <ea:DataLabel id="DOKUMENT" runat="server"></ea:DataLabel>
                        </FONT>
                    </TD>
				</TR>
            </TABLE>
			<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="0">
				<TR>
					<TD width="48%"><FONT face="Arial" size="1">06. Nazwisko</FONT></TD>
					<TD width="4%"></TD>
					<TD width="48%"><FONT face="Arial" size="1">07. Imię pierwsze</FONT></TD>
				</TR>
				<TR>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="NAZWISKO" runat="server"></ea:DataLabel></FONT>
                    </TD>
					<TD></TD>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="IMIE" runat="server"></ea:DataLabel></FONT>
                    </TD>
				</TR>
            </TABLE>
			<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="0">
				<TR>
					<TD valign="bottom" width="76%"><FONT face="Arial" size="1">08. Nazwa skrócona</FONT></TD>
					<TD width="4%"></TD>
					<TD width="20%"><FONT face="Arial" size="1">09. Data urodzenia</FONT></TD>
                </TR>
				<TR>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="NAZWASK" runat="server"></ea:DataLabel></FONT>
                    </TD>
					<TD></TD>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="URODZONY" runat="server"></ea:DataLabel></FONT>
                    </TD>
				</TR>
			</TABLE>
			<TABLE cellSpacing="0" cellPadding="0" height="8px"><TR><TD></TD></TR></TABLE>
			<TABLE id="Table9" cellSpacing="0" cellPadding="0" width="100%">
				<TR>
					<TD width="100%"><FONT face="Arial" size="1"><b>III. A. DANE IDENTYFIKACYJNE OSOBY UBEZPIECZONEJ</b></FONT></TD>
				</TR>
				<TR>
            </TABLE>
			<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="0">
				<TR>
					<TD><FONT face="Arial" size="1">01. Nazwisko</FONT></TD>
				</TR>
				<TR>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="PracNazw" runat="server"></ea:DataLabel></FONT>
                    </TD>
				</TR>
            </TABLE>
			<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="0">
				<TR>
					<TD width="48%"><FONT face="Arial" size="1">02. Imię pierwsze</FONT></TD>
					<TD width="4%"></TD>
					<TD width="20%"><FONT face="Arial" size="1">03. Typ</FONT></TD>
					<TD width="2%"></TD>
					<TD width="26%"><FONT face="Arial" size="1">04. Identyfikator</FONT></TD>
				</TR>
				<TR>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1"><ea:DataLabel id="PracImie" runat="server"></ea:DataLabel></FONT>
                    </TD>
					<TD></TD>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1">
                            <ea:DataLabel id="RODZAJUBEZP" runat="server"></ea:DataLabel>
                        </FONT>
                    </TD>
					<TD></TD>
					<TD style="BORDER-RIGHT: silver 1px solid; BORDER-TOP: silver 1px solid; BORDER-LEFT: silver 1px solid; BORDER-BOTTOM: silver 1px solid">
                        <FONT face="Arial" size="1">
                            <ea:DataLabel id="DOKUBEZP" runat="server" Format="{0}&amp;nbsp;"></ea:DataLabel>
                        </FONT>
                    </TD>
				</TR>
            </TABLE>
            <ea:DataRepeater id="DataRepeater1" runat="server" WithSections="False" OnBeforeRow="DataRepeater1_BeforeRow" Width="100%">
				<ea:Section runat="server" SectionType="InnerHeader"></ea:Section>
				<ea:Section runat="server" SectionType="Body">
				    <ea:Section id="Section1" runat="server">
                        <ea:DataLabel ID="DataRow1" runat="server" Bold="false"></ea:DataLabel>
                    </ea:Section>
				    <ea:Section id="Section2" runat="server">
                        <ea:DataLabel ID="DataRow2" runat="server" Bold="false"></ea:DataLabel>
                    </ea:Section>
				    <ea:Section id="Section3" runat="server">
                        <ea:DataLabel ID="DataRow3" runat="server" Bold="false"></ea:DataLabel>
                    </ea:Section>
                </ea:Section>
				<ea:Section runat="server" SectionType="InnerFooter"></ea:Section>
            </ea:DataRepeater>
			<TABLE id="Table66" cellSpacing="0" cellPadding="0" height="8px"><TR><TD></TD></TR></TABLE>
            <ea:PageBreak ID="PageBreak1" runat="server" Required="false"></ea:PageBreak>
            <TABLE id="Table67" cellSpacing="0" cellPadding="0" width="100%">
				<TR>
					<TD width="90%"><FONT face="Arial" size="1"><b>IV. OŚWIADCZENIE PŁATNIKA SKŁADEK</b></FONT></TD>
				</TR>
            </TABLE>
			<TABLE cellSpacing="0" cellPadding="0" height="8px"><TR><TD></TD></TR></TABLE>
			<TABLE id="Table66" cellSpacing="0" cellPadding="0" width="40%">
				<TR>
					<TD width="70%"><FONT face="Arial" size="1">01. Data wypełnienia (dd/mm/rrrr)</FONT></TD>
					<TD width="30%" style="BORDER:silver 1px solid"><FONT face="Arial" size="1"><ea:DataLabel runat="server" DataMember="Data"></ea:DataLabel></FONT></TD>
				</TR>
            </TABLE>
			<TABLE cellSpacing="0" cellPadding="0" height="8px"><TR><TD></TD></TR></TABLE>
			<TABLE id="Table67" cellSpacing="0" cellPadding="0" width="100%">
				<TR>
					<TD width="90%"><FONT face="Arial" size="1"><b>Oświadczam, że dane zawarte w formularzu są zgodne ze stanem prawnym i faktycznym. Jestem świadomy (-ma) odpowiedzialności karnej za zeznanie nieprawdy lub zatajenie prawdy.</b></FONT></TD>
				</TR>
            </TABLE>
			<TABLE cellSpacing="0" cellPadding="0" height="8px"><TR><TD></TD></TR></TABLE>
            <cc1:reportfooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Empty" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="02. Podpis płatnika składek lub osoby przez niego upoważnionej oraz pieczątka adresowa płatnika" Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
            <br />
			<TABLE id="Table67" cellSpacing="0" cellPadding="0" width="100%">
				<TR>
					<TD width="100%" style="font-family: Arial; font-size: 8px;">
                        <sup>1)</sup> Numer PESEL podaje się, o ile został nadany.
					</TD>
				</TR>
				<TR>
					<TD width="100%" style="font-family: Arial; font-size: 8px;">
                        <sup>2)</sup> Pól nie wypełnia się w dokumentach za okres stycznia 2008 r., a w razie składania korekt za okres do grudnia 2007r.
                        może zostać wykazana kwota, nie wyższa od kwoty dofinansowania uwzględnionego w deklaracji za ten okres złożonej nie później niż do 30 czerwca 2008 r.
					</TD>
				</TR>
            </TABLE>
		</form>
	</body>
</HTML>
